%------------------------------------------------------------------------------
% File     : LCL944^8 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Logic Calculi
% Problem  : Goedel translation of LCL455+1 (from TPTP-v5.0.0)
% Version  : [BP13] axioms.
% English  : 

% Refs     : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : GLC455+1 [QMLTP]

% Status   : Theorem 
% Rating   : 0.44 v9.1.0, 0.38 v9.0.0, 0.40 v8.2.0, 0.46 v8.1.0
% Syntax   : Number of formulae    :  130 (  12 unt;  52 typ;  10 def)
%            Number of atoms       :  914 (  10 equ;   0 cnn)
%            Maximal formula atoms :   36 (  11 avg)
%            Number of connectives : 1376 (   1   ~;   1   |;   3   &;1367   @)
%                                         (   1 <=>;   3  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (  11 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :  104 ( 104   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   52 (  51 usr;   1 con; 0-3 aty)
%            Number of variables   :  184 ( 177   ^;   4   !;   3   ?; 184   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $varying,
%            $modalities == $modal_system_T].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mrel_type,type,
    mrel: mworld > mworld > $o ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(mrel_reflexive,axiom,
    ! [W: mworld] : ( mrel @ W @ W ) ).

thf(eiw_di_type,type,
    eiw_di: $i > mworld > $o ).

thf(eiw_di_nonempty,axiom,
    ! [W: mworld] :
    ? [X: $i] : ( eiw_di @ X @ W ) ).

thf(mforall_di_type,type,
    mforall_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mforall_di_def,definition,
    ( mforall_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ! [X: $i] :
          ( ( eiw_di @ X @ W )
         => ( A @ X @ W ) ) ) ) ).

thf(mexists_di_type,type,
    mexists_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mexists_di_def,definition,
    ( mexists_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ? [X: $i] :
          ( ( eiw_di @ X @ W )
          & ( A @ X @ W ) ) ) ) ).

thf(r2_decl,type,
    r2: mworld > $o ).

thf(r3_decl,type,
    r3: mworld > $o ).

thf(r4_decl,type,
    r4: mworld > $o ).

thf(r5_decl,type,
    r5: mworld > $o ).

thf(equivalence_1_decl,type,
    equivalence_1: mworld > $o ).

thf(equivalence_2_decl,type,
    equivalence_2: mworld > $o ).

thf(cn2_decl,type,
    cn2: mworld > $o ).

thf(cn1_decl,type,
    cn1: mworld > $o ).

thf(cn3_decl,type,
    cn3: mworld > $o ).

thf(kn2_decl,type,
    kn2: mworld > $o ).

thf(kn1_decl,type,
    kn1: mworld > $o ).

thf(kn3_decl,type,
    kn3: mworld > $o ).

thf(equivalence_3_decl,type,
    equivalence_3: mworld > $o ).

thf(op_implies_or_decl,type,
    op_implies_or: mworld > $o ).

thf(op_and_decl,type,
    op_and: mworld > $o ).

thf(and_2_decl,type,
    and_2: mworld > $o ).

thf(and_3_decl,type,
    and_3: mworld > $o ).

thf(and_1_decl,type,
    and_1: mworld > $o ).

thf(implies_2_decl,type,
    implies_2: mworld > $o ).

thf(implies_3_decl,type,
    implies_3: mworld > $o ).

thf(op_implies_and_decl,type,
    op_implies_and: mworld > $o ).

thf(implies_1_decl,type,
    implies_1: mworld > $o ).

thf(substitution_of_equivalents_decl,type,
    substitution_of_equivalents: mworld > $o ).

thf(op_or_decl,type,
    op_or: mworld > $o ).

thf(modus_tollens_decl,type,
    modus_tollens: mworld > $o ).

thf(or_1_decl,type,
    or_1: mworld > $o ).

thf(or_2_decl,type,
    or_2: mworld > $o ).

thf(or_3_decl,type,
    or_3: mworld > $o ).

thf(op_equiv_decl,type,
    op_equiv: mworld > $o ).

thf(modus_ponens_decl,type,
    modus_ponens: mworld > $o ).

thf(r1_decl,type,
    r1: mworld > $o ).

thf(qmltpeq_decl,type,
    qmltpeq: $i > $i > mworld > $o ).

thf(is_a_theorem_decl,type,
    is_a_theorem: $i > mworld > $o ).

thf(equiv_decl,type,
    equiv: $i > $i > $i ).

thf(not_decl,type,
    not: $i > $i ).

thf(or_decl,type,
    or: $i > $i > $i ).

thf(and_decl,type,
    and: $i > $i > $i ).

thf(implies_decl,type,
    implies: $i > $i > $i ).

thf(reflexivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( qmltpeq @ X @ X ) ) ) ) ) ).

thf(symmetry,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mbox @ ( qmltpeq @ Y @ X ) ) ) ) ) ) ) ) ) ).

thf(transitivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mbox @ ( qmltpeq @ Y @ Z ) ) ) @ ( mbox @ ( qmltpeq @ X @ Z ) ) ) ) ) ) ) ) ) ) ) ).

thf(and_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( and @ A @ C ) @ ( and @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(and_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( and @ C @ A ) @ ( and @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(equiv_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( equiv @ A @ C ) @ ( equiv @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(equiv_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( equiv @ C @ A ) @ ( equiv @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(implies_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( implies @ A @ C ) @ ( implies @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(implies_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( implies @ C @ A ) @ ( implies @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(not_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( not @ A ) @ ( not @ B ) ) ) ) ) ) ) ) ) ) ).

thf(or_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( or @ A @ C ) @ ( or @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(or_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( or @ C @ A ) @ ( or @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(is_a_theorem_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( is_a_theorem @ A ) ) ) @ ( mbox @ ( is_a_theorem @ B ) ) ) ) ) ) ) ) ) ).

thf(modus_ponens_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ modus_ponens )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( is_a_theorem @ X ) ) @ ( mbox @ ( is_a_theorem @ ( implies @ X @ Y ) ) ) ) @ ( mbox @ ( is_a_theorem @ Y ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( is_a_theorem @ X ) ) @ ( mbox @ ( is_a_theorem @ ( implies @ X @ Y ) ) ) ) @ ( mbox @ ( is_a_theorem @ Y ) ) ) ) ) ) ) )
          @ ( mbox @ modus_ponens ) ) ) ) ) ).

thf(substitution_of_equivalents_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ substitution_of_equivalents )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( is_a_theorem @ ( equiv @ X @ Y ) ) ) @ ( mbox @ ( qmltpeq @ X @ Y ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( is_a_theorem @ ( equiv @ X @ Y ) ) ) @ ( mbox @ ( qmltpeq @ X @ Y ) ) ) ) ) ) ) )
          @ ( mbox @ substitution_of_equivalents ) ) ) ) ) ).

thf(modus_tollens_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ modus_tollens )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ ( not @ Y ) @ ( not @ X ) ) @ ( implies @ X @ Y ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ ( not @ Y ) @ ( not @ X ) ) @ ( implies @ X @ Y ) ) ) ) ) ) ) )
          @ ( mbox @ modus_tollens ) ) ) ) ) ).

thf(implies_1_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ implies_1 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ X @ ( implies @ Y @ X ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ X @ ( implies @ Y @ X ) ) ) ) ) ) ) )
          @ ( mbox @ implies_1 ) ) ) ) ) ).

thf(implies_2_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ implies_2 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ X @ ( implies @ X @ Y ) ) @ ( implies @ X @ Y ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ X @ ( implies @ X @ Y ) ) @ ( implies @ X @ Y ) ) ) ) ) ) ) )
          @ ( mbox @ implies_2 ) ) ) ) ) ).

thf(implies_3_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ implies_3 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [Z: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ X @ Y ) @ ( implies @ ( implies @ Y @ Z ) @ ( implies @ X @ Z ) ) ) ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [Z: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ X @ Y ) @ ( implies @ ( implies @ Y @ Z ) @ ( implies @ X @ Z ) ) ) ) ) ) ) ) ) ) )
          @ ( mbox @ implies_3 ) ) ) ) ) ).

thf(and_1_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ and_1 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( and @ X @ Y ) @ X ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( and @ X @ Y ) @ X ) ) ) ) ) ) )
          @ ( mbox @ and_1 ) ) ) ) ) ).

thf(and_2_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ and_2 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( and @ X @ Y ) @ Y ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( and @ X @ Y ) @ Y ) ) ) ) ) ) )
          @ ( mbox @ and_2 ) ) ) ) ) ).

thf(and_3_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ and_3 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ X @ ( implies @ Y @ ( and @ X @ Y ) ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ X @ ( implies @ Y @ ( and @ X @ Y ) ) ) ) ) ) ) ) )
          @ ( mbox @ and_3 ) ) ) ) ) ).

thf(or_1_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ or_1 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ X @ ( or @ X @ Y ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ X @ ( or @ X @ Y ) ) ) ) ) ) ) )
          @ ( mbox @ or_1 ) ) ) ) ) ).

thf(or_2_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ or_2 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ Y @ ( or @ X @ Y ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ Y @ ( or @ X @ Y ) ) ) ) ) ) ) )
          @ ( mbox @ or_2 ) ) ) ) ) ).

thf(or_3_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ or_3 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [Z: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ X @ Z ) @ ( implies @ ( implies @ Y @ Z ) @ ( implies @ ( or @ X @ Y ) @ Z ) ) ) ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [Z: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ X @ Z ) @ ( implies @ ( implies @ Y @ Z ) @ ( implies @ ( or @ X @ Y ) @ Z ) ) ) ) ) ) ) ) ) ) )
          @ ( mbox @ or_3 ) ) ) ) ) ).

thf(equivalence_1_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ equivalence_1 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( equiv @ X @ Y ) @ ( implies @ X @ Y ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( equiv @ X @ Y ) @ ( implies @ X @ Y ) ) ) ) ) ) ) )
          @ ( mbox @ equivalence_1 ) ) ) ) ) ).

thf(equivalence_2_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ equivalence_2 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( equiv @ X @ Y ) @ ( implies @ Y @ X ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( equiv @ X @ Y ) @ ( implies @ Y @ X ) ) ) ) ) ) ) )
          @ ( mbox @ equivalence_2 ) ) ) ) ) ).

thf(equivalence_3_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ equivalence_3 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ X @ Y ) @ ( implies @ ( implies @ Y @ X ) @ ( equiv @ X @ Y ) ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ X @ Y ) @ ( implies @ ( implies @ Y @ X ) @ ( equiv @ X @ Y ) ) ) ) ) ) ) ) )
          @ ( mbox @ equivalence_3 ) ) ) ) ) ).

thf(kn1_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ kn1 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] : ( mbox @ ( is_a_theorem @ ( implies @ P @ ( and @ P @ P ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] : ( mbox @ ( is_a_theorem @ ( implies @ P @ ( and @ P @ P ) ) ) ) ) )
          @ ( mbox @ kn1 ) ) ) ) ) ).

thf(kn2_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ kn2 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( and @ P @ Q ) @ P ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( and @ P @ Q ) @ P ) ) ) ) ) ) )
          @ ( mbox @ kn2 ) ) ) ) ) ).

thf(kn3_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ kn3 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [R: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ P @ Q ) @ ( implies @ ( not @ ( and @ Q @ R ) ) @ ( not @ ( and @ R @ P ) ) ) ) ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [R: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ P @ Q ) @ ( implies @ ( not @ ( and @ Q @ R ) ) @ ( not @ ( and @ R @ P ) ) ) ) ) ) ) ) ) ) ) )
          @ ( mbox @ kn3 ) ) ) ) ) ).

thf(cn1_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ cn1 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [R: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ P @ Q ) @ ( implies @ ( implies @ Q @ R ) @ ( implies @ P @ R ) ) ) ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [R: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ P @ Q ) @ ( implies @ ( implies @ Q @ R ) @ ( implies @ P @ R ) ) ) ) ) ) ) ) ) ) )
          @ ( mbox @ cn1 ) ) ) ) ) ).

thf(cn2_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ cn2 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] : ( mbox @ ( is_a_theorem @ ( implies @ P @ ( implies @ ( not @ P ) @ Q ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] : ( mbox @ ( is_a_theorem @ ( implies @ P @ ( implies @ ( not @ P ) @ Q ) ) ) ) ) ) ) )
          @ ( mbox @ cn2 ) ) ) ) ) ).

thf(cn3_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ cn3 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ ( not @ P ) @ P ) @ P ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ ( not @ P ) @ P ) @ P ) ) ) ) )
          @ ( mbox @ cn3 ) ) ) ) ) ).

thf(r1_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ r1 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( or @ P @ P ) @ P ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( or @ P @ P ) @ P ) ) ) ) )
          @ ( mbox @ r1 ) ) ) ) ) ).

thf(r2_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ r2 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] : ( mbox @ ( is_a_theorem @ ( implies @ Q @ ( or @ P @ Q ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] : ( mbox @ ( is_a_theorem @ ( implies @ Q @ ( or @ P @ Q ) ) ) ) ) ) ) )
          @ ( mbox @ r2 ) ) ) ) ) ).

thf(r3_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ r3 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( or @ P @ Q ) @ ( or @ Q @ P ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( or @ P @ Q ) @ ( or @ Q @ P ) ) ) ) ) ) ) )
          @ ( mbox @ r3 ) ) ) ) ) ).

thf(r4_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ r4 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [R: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( or @ P @ ( or @ Q @ R ) ) @ ( or @ Q @ ( or @ P @ R ) ) ) ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [R: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( or @ P @ ( or @ Q @ R ) ) @ ( or @ Q @ ( or @ P @ R ) ) ) ) ) ) ) ) ) ) )
          @ ( mbox @ r4 ) ) ) ) ) ).

thf(r5_0,axiom,
    ( mlocal
    @ ( mand
      @ ( mbox
        @ ( mimplies @ ( mbox @ r5 )
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [R: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ Q @ R ) @ ( implies @ ( or @ P @ Q ) @ ( or @ P @ R ) ) ) ) ) ) ) ) ) ) ) ) )
      @ ( mbox
        @ ( mimplies
          @ ( mbox
            @ ( mforall_di
              @ ^ [P: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Q: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [R: $i] : ( mbox @ ( is_a_theorem @ ( implies @ ( implies @ Q @ R ) @ ( implies @ ( or @ P @ Q ) @ ( or @ P @ R ) ) ) ) ) ) ) ) ) ) )
          @ ( mbox @ r5 ) ) ) ) ) ).

thf(op_or_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mimplies @ ( mbox @ op_or )
        @ ( mbox
          @ ( mforall_di
            @ ^ [X: $i] :
                ( mbox
                @ ( mforall_di
                  @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( or @ X @ Y ) @ ( not @ ( and @ ( not @ X ) @ ( not @ Y ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(op_and_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mimplies @ ( mbox @ op_and )
        @ ( mbox
          @ ( mforall_di
            @ ^ [X: $i] :
                ( mbox
                @ ( mforall_di
                  @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( and @ X @ Y ) @ ( not @ ( or @ ( not @ X ) @ ( not @ Y ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(op_implies_and_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mimplies @ ( mbox @ op_implies_and )
        @ ( mbox
          @ ( mforall_di
            @ ^ [X: $i] :
                ( mbox
                @ ( mforall_di
                  @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( implies @ X @ Y ) @ ( not @ ( and @ X @ ( not @ Y ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(op_implies_or_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mimplies @ ( mbox @ op_implies_or )
        @ ( mbox
          @ ( mforall_di
            @ ^ [X: $i] :
                ( mbox
                @ ( mforall_di
                  @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( implies @ X @ Y ) @ ( or @ ( not @ X ) @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(op_equiv_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mimplies @ ( mbox @ op_equiv )
        @ ( mbox
          @ ( mforall_di
            @ ^ [X: $i] :
                ( mbox
                @ ( mforall_di
                  @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( equiv @ X @ Y ) @ ( and @ ( implies @ X @ Y ) @ ( implies @ Y @ X ) ) ) ) ) ) ) ) ) ) ) ).

thf(hilbert_op_or,axiom,
    mlocal @ ( mbox @ op_or ) ).

thf(hilbert_op_implies_and,axiom,
    mlocal @ ( mbox @ op_implies_and ) ).

thf(hilbert_op_equiv,axiom,
    mlocal @ ( mbox @ op_equiv ) ).

thf(hilbert_modus_ponens,axiom,
    mlocal @ ( mbox @ modus_ponens ) ).

thf(hilbert_modus_tollens,axiom,
    mlocal @ ( mbox @ modus_tollens ) ).

thf(hilbert_implies_1,axiom,
    mlocal @ ( mbox @ implies_1 ) ).

thf(hilbert_implies_2,axiom,
    mlocal @ ( mbox @ implies_2 ) ).

thf(hilbert_implies_3,axiom,
    mlocal @ ( mbox @ implies_3 ) ).

thf(hilbert_and_1,axiom,
    mlocal @ ( mbox @ and_1 ) ).

thf(hilbert_and_2,axiom,
    mlocal @ ( mbox @ and_2 ) ).

thf(hilbert_and_3,axiom,
    mlocal @ ( mbox @ and_3 ) ).

thf(hilbert_or_1,axiom,
    mlocal @ ( mbox @ or_1 ) ).

thf(hilbert_or_2,axiom,
    mlocal @ ( mbox @ or_2 ) ).

thf(hilbert_or_3,axiom,
    mlocal @ ( mbox @ or_3 ) ).

thf(hilbert_equivalence_1,axiom,
    mlocal @ ( mbox @ equivalence_1 ) ).

thf(hilbert_equivalence_2,axiom,
    mlocal @ ( mbox @ equivalence_2 ) ).

thf(hilbert_equivalence_3,axiom,
    mlocal @ ( mbox @ equivalence_3 ) ).

thf(substitution_of_equivalents_1,axiom,
    mlocal @ ( mbox @ substitution_of_equivalents ) ).

thf(principia_op_implies_or,axiom,
    mlocal @ ( mbox @ op_implies_or ) ).

thf(principia_op_and,axiom,
    mlocal @ ( mbox @ op_and ) ).

thf(principia_op_equiv,axiom,
    mlocal @ ( mbox @ op_equiv ) ).

thf(principia_r2,conjecture,
    mlocal @ ( mbox @ r2 ) ).

%------------------------------------------------------------------------------
